<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        // Transactions performance indexes
        Schema::table('transactions', function (Blueprint $table) {
            $table->index(['business_id', 'type', 'status'], 'trx_biz_type_status_idx');
            $table->index(['business_id', 'type', 'location_id'], 'trx_biz_type_loc_idx');
            $table->index(['business_id', 'type', 'transaction_date'], 'trx_biz_type_tdate_idx');
            $table->index(['business_id', 'type', 'delivery_date'], 'trx_biz_type_ddate_idx');
            $table->index(['approval_status'], 'trx_approval_status_idx');
            $table->index(['created_by'], 'trx_created_by_idx');
        });

        // Purchase lines
        Schema::table('purchase_lines', function (Blueprint $table) {
            $table->index(['transaction_id'], 'pl_transaction_id_idx');
            $table->index(['product_id'], 'pl_product_id_idx');
            $table->index(['variation_id'], 'pl_variation_id_idx');
            $table->index(['purchase_requisition_line_id'], 'pl_pr_line_id_idx');
        });

        // Variations
        Schema::table('variations', function (Blueprint $table) {
            $table->index(['product_variation_id'], 'var_prod_variation_id_idx');
            $table->index(['deleted_at'], 'var_deleted_at_idx');
        });

        // Variation Location Details
        Schema::table('variation_location_details', function (Blueprint $table) {
            $table->index(['variation_id', 'location_id'], 'vld_variation_location_idx');
        });

        // Products
        Schema::table('products', function (Blueprint $table) {
            $table->index(['business_id', 'enable_stock', 'is_inactive'], 'prod_biz_stock_active_idx');
            $table->index(['alert_quantity'], 'prod_alert_qty_idx');
            $table->index(['category_id'], 'prod_category_id_idx');
            $table->index(['brand_id'], 'prod_brand_id_idx');
            $table->index(['sku'], 'prod_sku_idx');
            $table->index(['name'], 'prod_name_idx');
        });

        // Transaction sell lines (optimize sell views & reports)
        if (Schema::hasTable('transaction_sell_lines')) {
            Schema::table('transaction_sell_lines', function (Blueprint $table) {
                $table->index(['transaction_id'], 'tsl_transaction_id_idx');
                $table->index(['product_id'], 'tsl_product_id_idx');
                $table->index(['variation_id'], 'tsl_variation_id_idx');
                $table->index(['parent_sell_line_id'], 'tsl_parent_line_id_idx');
            });
        }

        // Transaction payments
        if (Schema::hasTable('transaction_payments')) {
            Schema::table('transaction_payments', function (Blueprint $table) {
                $table->index(['transaction_id'], 'tp_transaction_id_idx');
                $table->index(['payment_ref_no'], 'tp_payment_ref_no_idx');
                $table->index(['method'], 'tp_method_idx');
            });
        }
    }

    public function down(): void
    {
        // Keep indexes on rollback to avoid downtime; drop only if necessary.
    }
};
